* Title: 	atus_clean.do
* Version: 	23 May 2018
* Purpose: 	Clean data from IPUMS ATUS extract and create new variables


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using log/atus_clean, replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use dta/raw/atus_raw, clear

* Keep only 2003-2016
keep if year>=2003 & year<=2016


*******************************************************************************
* (2) Create data labels
*******************************************************************************

label define yesno 1 yes 0 no	
		

*******************************************************************************
* (3) Create new variables (core/geography)
*******************************************************************************
				 
* Merge with indicator for region
merge m:1 statefip using dta/state_region, assert(matched) nogen


*******************************************************************************
* (4) Create new variables (demographics)
*******************************************************************************

* Create dummy for prime-age male
generate PrimeMaleD = (age >=25 & age <=54 & sex == 1)

label var PrimeMaleD "Dummy for Prime Male"
notes PrimeMaleD: Dummy for prime male group \ atus_clean.do BA TS 
label values PrimeMaleD yesno


*******************************************************************************
* (5) Create new variables (labor force)
*******************************************************************************

* Create dummy for non-employment
generate UnempB = .
replace UnempB = 1 if (empstat >= 03 & empstat < 99)
replace UnempB = 0 if (empstat == 01 | empstat == 02)

label var UnempB "Dummy for not employed"
notes UnempB: Dummy for not employed \ atus_clean.do BA TS 
label values UnempB yesno


*******************************************************************************
* (6) Create new variables (time use)
*******************************************************************************

gen T_PersonalCare = bls_pcare
gen T_HouseholdAct = bls_hhact
gen T_Food = bls_food
gen T_CareOthers = bls_carehh + bls_carenhh
gen T_TotalWork = bls_work
gen T_LookingWork = bls_work_search
gen T_Education = bls_educ
gen T_TotalLeisure = bls_leis
gen T_Socializing = bls_leis_soccom
gen T_TV = bls_leis_tv
gen T_ComputerUse = computer_use


*******************************************************************************
* (7) Restrict sample
*******************************************************************************

* Keep only ages 16+
keep if age>=16 & !mi(age)


*******************************************************************************
* (8) End of file
*******************************************************************************
assert !mi(UnempB)
compress

label data "Create ATUS data \ 05-23-2018"
notes: atus_clean \ Clean data created from atus_raw ///
	   \ atus_clean.do \ BA TS 
datasignature set
save dta/atus_clean, replace

log close
exit, clear
